/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.render.item;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gg.moonflower.etched.api.record.AlbumCover;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.client.render.item.ImageAlbumCover;
import gg.moonflower.etched.client.render.item.ModelAlbumCover;
import gg.moonflower.etched.common.item.AlbumCoverItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.ApiStatus;

public class AlbumCoverItemRenderer
extends BlockEntityWithoutLevelRenderer
implements PreparableReloadListener {
    public static final AlbumCoverItemRenderer INSTANCE = new AlbumCoverItemRenderer();
    public static final String FOLDER_NAME = "etched_album_cover";
    private static final ModelResourceLocation BLANK_ALBUM_COVER = new ModelResourceLocation(new ResourceLocation("etched", "etched_album_cover/blank"), "inventory");
    private static final ModelResourceLocation DEFAULT_ALBUM_COVER = new ModelResourceLocation(new ResourceLocation("etched", "etched_album_cover/default"), "inventory");
    private static final ResourceLocation ALBUM_COVER_OVERLAY = new ResourceLocation("etched", "textures/item/album_cover_overlay.png");
    private static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    private static final BlockModel MODEL = BlockModel.m_111463_((String)"{\"gui_light\":\"front\",\"textures\":{\"layer0\":\"texture\"},\"display\":{\"ground\":{\"rotation\":[0,0,0],\"translation\":[0,2,0],\"scale\":[0.5,0.5,0.5]},\"head\":{\"rotation\":[0,180,0],\"translation\":[0,13,7],\"scale\":[1,1,1]},\"thirdperson_righthand\":{\"rotation\":[0,0,0],\"translation\":[0,3,1],\"scale\":[0.55,0.55,0.55]},\"firstperson_righthand\":{\"rotation\":[0,-90,25],\"translation\":[1.13,3.2,1.13],\"scale\":[0.68,0.68,0.68]},\"fixed\":{\"rotation\":[0,180,0],\"scale\":[1,1,1]}}}");
    private final Map<CompoundTag, CompletableFuture<ModelData>> covers = new HashMap<CompoundTag, CompletableFuture<ModelData>>();
    private CoverData data = null;

    private AlbumCoverItemRenderer() {
        super(null, null);
    }

    @Deprecated
    public static void init() {
    }

    public static NativeImage getOverlayImage() {
        return AlbumCoverItemRenderer.INSTANCE.data.overlay.getImage();
    }

    private static void renderModelLists(BakedModel model, int combinedLight, int combinedOverlay, PoseStack matrixStack, VertexConsumer buffer, RenderType renderType) {
        RandomSource randomsource = RandomSource.m_216327_();
        for (Direction direction : Direction.values()) {
            randomsource.m_188584_(42L);
            AlbumCoverItemRenderer.renderQuadList(matrixStack, buffer, model.getQuads(null, direction, randomsource, net.minecraftforge.client.model.data.ModelData.EMPTY, renderType), combinedLight, combinedOverlay);
        }
        randomsource.m_188584_(42L);
        AlbumCoverItemRenderer.renderQuadList(matrixStack, buffer, model.getQuads(null, null, randomsource, net.minecraftforge.client.model.data.ModelData.EMPTY, renderType), combinedLight, combinedOverlay);
    }

    private static void renderQuadList(PoseStack matrixStack, VertexConsumer buffer, List<BakedQuad> quads, int combinedLight, int combinedOverlay) {
        PoseStack.Pose pose = matrixStack.m_85850_();
        for (BakedQuad bakedQuad : quads) {
            buffer.m_85987_(pose, bakedQuad, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay);
        }
    }

    private static NativeImage getCoverOverlay(ResourceManager resourceManager) {
        NativeImage nativeImage;
        block11: {
            InputStream stream = resourceManager.m_215593_(ALBUM_COVER_OVERLAY).m_215507_();
            try {
                nativeImage = NativeImage.m_85058_((InputStream)stream);
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    NativeImage nativeImage2 = new NativeImage(16, 16, false);
                    for (int k = 0; k < 16; ++k) {
                        for (int l = 0; l < 16; ++l) {
                            if (k < 8 ^ l < 8) {
                                nativeImage2.m_84988_(l, k, -524040);
                                continue;
                            }
                            nativeImage2.m_84988_(l, k, -16777216);
                        }
                    }
                    nativeImage2.m_85123_();
                    return nativeImage2;
                }
            }
            stream.close();
        }
        return nativeImage;
    }

    private void close() {
        this.covers.values().forEach(future -> future.thenAcceptAsync(data -> {
            if (!this.data.is((ModelData)data)) {
                data.close();
            }
        }, task -> RenderSystem.recordRenderCall(task::run)));
        this.covers.clear();
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> new CoverData(AlbumCoverItemRenderer.getCoverOverlay(resourceManager)), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0))).thenAcceptAsync(data -> {
            if (this.data != null) {
                this.data.close();
            }
            this.data = data;
            this.close();
        }, gameExecutor);
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (stack.m_41619_()) {
            return;
        }
        ModelData model = stack.m_41737_("CoverRecord") == null ? this.data.defaultCover : this.covers.computeIfAbsent(stack.m_41737_("CoverRecord"), __ -> {
            ItemStack coverStack = AlbumCoverItem.getCoverStack(stack).orElse(ItemStack.f_41583_);
            if (!coverStack.m_41619_() && coverStack.m_41720_() instanceof PlayableRecord) {
                return ((CompletableFuture)((PlayableRecord)coverStack.m_41720_()).getAlbumCover(coverStack, Minecraft.m_91087_().m_91096_(), Minecraft.m_91087_().m_91098_()).thenApply(cover -> ModelData.of(cover).orElse(this.data.defaultCover))).exceptionally(e -> {
                    e.printStackTrace();
                    return this.data.defaultCover;
                });
            }
            return CompletableFuture.completedFuture(this.data.defaultCover);
        }).getNow(this.data.defaultCover);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        model.render(stack, displayContext, poseStack, buffer, packedLight, packedOverlay);
        poseStack.m_85849_();
    }

    static {
        MinecraftForge.EVENT_BUS.addListener(event -> INSTANCE.close());
    }

    public static class CoverData {
        private final DynamicModelData overlay;
        private final ModelData blank;
        private final ModelData defaultCover;

        private CoverData(NativeImage overlay) {
            this.overlay = new DynamicModelData(overlay);
            this.blank = new BakedModelData(BLANK_ALBUM_COVER);
            this.defaultCover = new BakedModelData(DEFAULT_ALBUM_COVER);
        }

        public void close() {
            this.overlay.close();
            this.blank.close();
            this.defaultCover.close();
        }

        public boolean is(ModelData data) {
            return this.overlay == data || this.blank == data || this.defaultCover == data;
        }
    }

    private static class DynamicModelData
    extends TextureAtlasSprite
    implements ModelData {
        private static final ResourceLocation ATLAS = new ResourceLocation("etched", DigestUtils.md5Hex((String)UUID.randomUUID().toString()));
        private BakedModel model;

        private DynamicModelData(NativeImage image) {
            super(ATLAS, new SpriteContents(new ResourceLocation("etched", DigestUtils.md5Hex((String)UUID.randomUUID().toString())), new FrameSize(image.m_84982_(), image.m_85084_()), image, AnimationMetadataSection.f_119012_, null), image.m_84982_(), image.m_85084_(), 0, 0);
        }

        @Override
        public void render(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int combinedOverlay) {
            BakedModel model = this.getModel();
            if (model.m_7521_()) {
                return;
            }
            model.applyTransform(transformType, matrixStack, transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND);
            matrixStack.m_85837_(-0.5, -0.5, -0.5);
            RenderType renderType = RenderType.m_110452_((ResourceLocation)this.m_245424_().m_246162_());
            AlbumCoverItemRenderer.renderModelLists(model, packedLight, combinedOverlay, matrixStack, ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)false, (boolean)stack.m_41790_()), renderType);
        }

        private BakedModel getModel() {
            TextureManager textureManager;
            ResourceLocation name = this.m_245424_().m_246162_();
            if (this.model == null) {
                ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
                profiler.m_6180_("buildAlbumCoverModel");
                this.model = ITEM_MODEL_GENERATOR.m_111670_(material -> this, MODEL).m_111449_(null, MODEL, material -> this, (ModelState)BlockModelRotation.X0_Y0, name, false);
                profiler.m_7238_();
            }
            if ((textureManager = Minecraft.m_91087_().m_91097_()).m_174786_(name, null) == null) {
                textureManager.m_118495_(name, (AbstractTexture)new DynamicTexture(this.getImage()));
            }
            return this.model;
        }

        public NativeImage getImage() {
            return this.m_245424_().getOriginalImage();
        }

        public float m_118417_() {
            return 0.0f;
        }

        public VertexConsumer m_118381_(VertexConsumer buffer) {
            return buffer;
        }

        @Override
        public void close() {
            this.m_245424_().close();
            Minecraft.m_91087_().m_91097_().m_118513_(this.m_245424_().m_246162_());
        }
    }

    @ApiStatus.Internal
    public static interface ModelData {
        public static Optional<ModelData> of(AlbumCover cover) {
            if (cover instanceof ModelAlbumCover) {
                return Optional.of(new BakedModelData(((ModelAlbumCover)cover).model()));
            }
            if (cover instanceof ImageAlbumCover) {
                return Optional.of(new DynamicModelData(((ImageAlbumCover)cover).image()));
            }
            return Optional.empty();
        }

        public void render(ItemStack var1, ItemDisplayContext var2, PoseStack var3, MultiBufferSource var4, int var5, int var6);

        public void close();
    }

    private static class BakedModelData
    implements ModelData {
        private final ModelResourceLocation model;
        private boolean rendering;

        private BakedModelData(ModelResourceLocation model) {
            this.model = model;
        }

        @Override
        public void render(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int combinedOverlay) {
            ModelManager modelManager = Minecraft.m_91087_().m_91304_();
            BakedModel model = this.rendering ? modelManager.m_119409_() : modelManager.m_119422_(this.model);
            this.rendering = true;
            Minecraft.m_91087_().m_91291_().m_115143_(stack, transformType, transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND, matrixStack, buffer, packedLight, combinedOverlay, model);
            this.rendering = false;
        }

        @Override
        public void close() {
        }
    }
}

